# Basic TFT LCD display functions
#
# Clear Screen - wb32.cls()
#
# wb.cls()
# wb.cls(color）
#
# color: 0 ~ 65535
#   Black = 0
#   White = 65535 	(0xffff)
#   Red   = 248 	(0x00f8)
#   Greed = 57351 	(0xe007)
#   Blue = 7936 	(0x1f00)
#   Yellow = 57599 	(0xe0ff)
#   Purple = 8184 	(0x1ff8)
#   

wb.cls()
wb.cls(65535) # fill screen to red

# Draw a solid block
#
# wb.box(x, y1, w, h, color）
#
# x = 0 ~ 239
# y = 0 ~ 319
# w  = 1 ~ 240
# h  = 1 ~ 320
# color = 0 ~ 65535

wb.box(50, 10, 140, 50, 7936)

# Draw a line
#
# wb.line(x1, y1, x2, y2, color, width)
#
# x1,x2 = 0 ~ 239
# y1,y2 = 0 ~ 319
# color = 0 ~ 65535
# width  = 1 ~ 16

for y in range(90, 300, 20):
    wb.line(20, y, 220, y, y*20, 2)

# Draw a string 
#
# wb.str(str, x, y, font, size)
#
# str = (max 32 characters)
# x = 0 ~ 239
# y = 0 ~ 319
# font = 1 or 2
# size  = 1 ~ 24

# Set font colors
#
# wb.colors(front-color, back-color）
#
# if front-color = back-color, the character is transparent.
#

wb.colors(57599, 7936)
wb.str("WiFiBoy", 65, 20, 1, 4)

iFiBoy", 65, 20, 1, 4)

